# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 4
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR4_strategy.txt
# LLM Suggested Fallback: D

def harmony_seeker_optimized_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Reward mutual cooperation and maintain trust
    trust_score = sum(1 for move in opp_history if move == "C")
    current_round = len(my_history) + 1
    
    # Initial trust-building phase (Rounds 1-3)
    if current_round <= 3:
        if "D" in opp_history:
            return "D"  # Grim trigger if opponent defects early
        return "C"
    
    # Mid-game exploitation (Rounds 4-7)
    elif 4 <= current_round <= 7:
        if current_round == 4:
            if all(move == "C" for move in opp_history[:3]):
                return "D"  # Exploit opponent's trust
            else:
                return "C" if opp_history[-1] == "D" else "D"
        else:
            # Tit-for-Tat with defection bias
            if opp_history[-1] == "C":
                return "D"
            else:
                return "C" if random.random() < 0.3 else "D"  # Introduce randomness
    
    # Late-game aggression (Rounds 8-10)
    else:
        return "D"  # Unconditional defection to maximize payoff